package gov.va.vinci.dart.usr;

/** User preferences for custom authentication
 *
 */
public class UserPreferencesImpl implements UserPreferences {
	private static final long serialVersionUID = -4303520363875400319L;
	
//	private boolean initialized = false;
	private int userId = 5;  // TODO- keep this synchronized with the test database!
	private String loginId = "someuser";
	private String fullName = "User Full Name";
	private int facilityId = 139;
	private String emailAddress = "Some.    @domain";
	
	public UserPreferencesImpl() {
		
	}

	/** Get the user id the logged in user is known by in the database
	 * 
	 * @return the db user id
	 */
	@Override
	public int getUserId() {
		return userId; 
	}

	/** Get the user id the user logged in with 
	 * @return the login user id
	 */
	@Override
	public String getUserLoginId() {
		return loginId;
	}

	/** Get the user's full name
	 * 
	 */
	@Override
	public String getUserFullName() {
		return fullName;
	}
	
	/** Get the facility id the user works in
	 * 
	 * @return the facility id
	 */
	@Override
	public int getFacilityId() {
		return facilityId;
	}
	
	@Override
	public void setFacilityId(int facilityId) {
		this.facilityId = facilityId;
	}

	@Override
	public void setUserId(int userId) {
		this.userId = userId;
	}

	@Override
	public void setUserLoginId(String loginId) {
		this.loginId = loginId;
	}

	@Override
	public void setUserFullName(String fullName) {
		this.fullName = fullName;
	}

	@Override
	public String getUserEmailAddress() {
		return emailAddress;
	}

	@Override
	public void setUserEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
}
